//
//  CRPortsManager.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/24/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRSceneItemPort.h"
#import "CRSceneItemWrapperPort.h"
#import "CRSceneItemValuePort.h"

extern NSString* const CRDuplicatedPortNameException;

//////////////////////////////////////////////////////////////////////
// Port owner protocol
//////////////////////////////////////////////////////////////////////
@protocol CRPortsOwner
@optional

- (void)portIsDirty:(CRSceneItemPort *)port;
- (void)portRestrictionsWillChange:(CRSceneItemPort *)port;
- (void)portRestrictionsDidChange:(CRSceneItemPort *)port;

@end

//////////////////////////////////////////////////////////////////////
// Ports manager
//////////////////////////////////////////////////////////////////////
@interface CRPortsManager : NSObject
{
	id<CRPortsOwner> assigned	root;
	NSMutableDictionary*		ports;
	
@private
	NSMutableArray*				descriptors;
}

@property (nonatomic, assign, readonly)	id<CRPortsOwner>	root;
@property (nonatomic, readonly)			NSDictionary*		ports;
@property (nonatomic, readonly)			NSArray*			descriptors;

- (id)initWithRoot:(id)rootObject;
- (void)addPort:(CRSceneItemPort *)port;
- (void)rebuildDescriptors;

@end